module BlackJackTypes
open Mini

type PlayerState = { score : Nat ; active : Bool }

type MapUnsortedList<'k, 'v when 'k: equality> = List<'k * 'v>

type Players = MapUnsortedList<String, PlayerState>

// let keysAsList (map: Map<'k, 'v>): List<'k> =
//     Seq.toList (Map.keys map)

// let nextPlayer (currentPlayer: String) (states: Map<String, PlayerState>): Option<String> =
//     let asList = Map.toList states
//     let rec h (states: List<String*PlayerState>): Option<String> =
//         match states with
//             | [] | [_] -> None
//             | p1::p2::ps -> if (fst p1) = currentPlayer
//                             then if (snd p2).active
//                                  then Some (fst p2)
//                                  else h (p1::ps)
//                             else h (p2::ps)
//     let maybeNextPlayer = h (asList @ asList)
//     match maybeNextPlayer with
//         | None -> if (snd (List.head asList)).active then Some (fst (List.head asList)) else None
//         | p -> p

let rec insert<'k, 'v when 'k: equality> (key: 'k, value: 'v)
    (m: MapUnsortedList<'k, 'v>): MapUnsortedList<'k, 'v> =
    match m with
    | [] -> [(key, value)]
    | (k, v)::rest ->
        if k = key then (key, value)::rest
        else (k,v)::(insert (key, value) rest)

let rec tryFind<'k, 'v when 'k: equality> (key: 'k) (m: MapUnsortedList<'k, 'v>):
    Option<'v> =
    match m with
    | [] -> None
    | (k, v)::rest -> if k = key then Some v else tryFind key rest

let nextPlayer (currentPlayer: String) (states: MapUnsortedList<String, PlayerState>): Option<String> =
    let rec h (states: MapUnsortedList<String, PlayerState>): Option<String> =
        match states with
            | [] | [_] -> None
            | p1::p2::ps -> if (fst p1) = currentPlayer
                            then if (snd p2).active
                                 then Some (fst p2)
                                 else h (p1::ps)
                            else h (p2::ps)
    h (states @ states)
    //let maybeNextPlayer = h (states @ states)
    // match maybeNextPlayer with
    //     | None -> if (snd (List.head states)).active then Some (fst (List.head states)) else None
    //     | p -> p


let rnd = System.Random()

let gdpWuerfel (): Nat =
    Nat.Make (rnd.Next(1,6))
    
        
