[<AutoOpen>]
module Tests
open Mini

////types)
type A =
    interface
        abstract member f: Unit -> Nat
    end

type B =
    interface
        inherit A
        abstract member g: Nat -> String
    end

type C =
    interface
        inherit A
        abstract member h: String -> Nat
    end

type D =
    interface
        inherit C
        abstract member i: Nat -> Unit
    end
////tests)

let einA =
    { new A with
        member self.f () = 0N
    }

let einB =
    { new B with
        member self.f () = 2N
        member self.g x = "Zahl: " + (string x)
    }

let einC =
    { new C with
        member self.h str = str.Length |> Nat.Make
        member self.f () = 1N
    }

let einD =
    { new D with
        member self.f () = 7N
        member self.h str = str.Length |> Nat.Make
        member self.i x = putline (string x)
    }


// a)
let exA = fun (s : B * D) -> ((snd s) :> C).h ((fst s).g 1N)

// b)
let exB = fun (s: A -> D) -> (fun (b: B) -> (s b).f ())

////end)
